## Where Clause Exists

More about the slicer : i.e., behaviors related to tuple exists mechanism.




### Description

This section highlights several usage of the slicer related to tuple completion and exists mechanisms (i.e., tuple with several members of the same dimension).



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Calculated Member : tuple completion

</div>

<div class="ic3-mdx-example-body" style="display:none">

Calculated members are completed with the slicer content. Note, that hierarchies of the same dimension are also completed.

In our example, the slicer member [Geo].[France] is completing the [Economy] hierarchy members defined in the calculated member [sliced].

**Query**

```
WITH
    MEMBER [Measures].[sliced] AS Sum( [Geography].[Economy].[Country].members, [Measures].[Amount] )
SELECT
    { [Measures].[amount], [Measures].[sliced] } on 0
FROM
    [Sales]
WHERE
    ( [Geography].[Geo].[France] )
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Amount</td>
  <td class="ic3-mdx-result-cell-header">sliced</td>
</tr>
<tr>
 <td>4</td>
 <td>4</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[france]        AS ( [Geography].[Economy].[France], [Measures].[Amount] )
SELECT
    { [Measures].[france], [Measures].[france] } on 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Calculated Member : currentMember can retrieve the value of the slicer

</div>

<div class="ic3-mdx-example-body" style="display:none">

Let´s take the value of the filter by using currentMember in a calculated member.

**Query**

```
WITH
    MEMBER [Measures].[france] AS Sum( ( [Geography].[Economy].[Country].members, [Geography].[Geo].currentMember ), [Measures].[Amount] )
SELECT
    { [Measures].[france] } on 0
FROM
    [Sales]
WHERE
    ( [Geography].[Geo].[France] )
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">france</td>
</tr>
<tr>
 <td>4</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[france]  AS ( [Geography].[Economy].[France], [Measures].[Amount] )
SELECT
    { [Measures].[france] } on 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Hierarchy both in a calculated member and in one axis

</div>

<div class="ic3-mdx-example-body" style="display:none">

Another example of tuple completion and filtering.

In our example, the slicer filters the members function of axis 0 and applies to the calculated member [xx].

**Query**

```
WITH
    MEMBER [Measures].[xx] AS Sum( [Geography].[Economy].members, [Measures].[Amount] )
SELECT
    [Geography].[Economy].members on 0,
    { [Measures].[Amount], [Measures].[xx] } on 1
FROM
    [Sales]
WHERE
    ( [Geography].[Geo].[France] )
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">ALL</td>
  <td class="ic3-mdx-result-cell-header">EU</td>
  <td class="ic3-mdx-result-cell-header">France</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">Amount</td>
 <td>4</td>
 <td>4</td>
 <td>4</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">xx</td>
 <td>12</td>
 <td>12</td>
 <td>12</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[axis-sliced-amount]        AS ( [Geography].[Economy].[France], [Measures].[Amount] )
    MEMBER [Measures].[calc-member-sliced-amount] AS ( [Geography].[Economy].[France], [Measures].[Amount] ) * (1+[Geography].[Economy].[France].level.ordinal)
SELECT
    Hierarchize( Ascendants( [Geography].[Economy].[France] )) on 0,
    { [Measures].[axis-sliced-amount], [Measures].[calc-member-sliced-amount] } on 1
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Named Set and autoexists

</div>

<div class="ic3-mdx-example-body" style="display:none">

The set is being evaluated according to the slicer context and as for the axis an auto-exists is applied to all
set members (e.g. only economy members matching [France] are accepted). Note, how in the context
of a calculated member the slicer auto-exists is not applied.

**Query**

```
WITH
    MEMBER [Measures].[Set Count] AS Count( [my-set] )
    MEMBER [Measures].[No Set Count] AS Count( [Geography].[Economy].members )
    SET [my-set] AS [Geography].[Economy].members
SELECT
    { [Set Count], [No Set Count] } on 0,
    [Geography].[Economy].members on 1
FROM [Sales]
WHERE ( [Geography].[Geo].[Country].&[FR] )
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Set Count</td>
  <td class="ic3-mdx-result-cell-header">No Set Count</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">ALL</td>
 <td>3</td>
 <td>11</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;EU</td>
 <td>3</td>
 <td>11</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td>3</td>
 <td>11</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
	MEMBER [Measures].[Set Count] AS Count( [my-set] * [Geography].[Geo].[Country].&[FR] )
	MEMBER [Measures].[No Set Count] AS Count( [Geography].[Economy].members )
    SET [my-set] AS [Geography].[Economy].members
SELECT
	{ [Set Count], [No Set Count] } on 0,
	// Do the same as the auto-exists that is applied in the where clause in the former example
    Extract([Geography].[Economy].members  * [Geography].[Geo].[Country].&[FR], [Geography].[Economy])  on 1
FROM [Sales]
```


**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Set Count] AS Count( [my-set] )
    MEMBER [Measures].[No Set Count] AS Count( [Geography].[Economy].members )
    SET [my-set] AS IIF( COUNT([Geography].[Economy].members) = 3,[Geography].[Economy].members, {} )
SELECT
    { [Set Count], [No Set Count] } on 0,
    [Geography].[Economy].members on 1
FROM [Sales]
WHERE ( [Geography].[Geo].[Country].&[FR] )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Showing the dimension is filtered

</div>

<div class="ic3-mdx-example-body" style="display:none">

Within the axis evaluation, the dimension [Geography] members are filtered according to the slicer.

**Query**

```
SELECT
    Head( [Time].[Calendar].[Month].members , Count( [Geography].[Economy].members )) on 0
FROM
    [Sales]
WHERE
    ( [Geography].[Geo].[France] )
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Jan 2010</td>
  <td class="ic3-mdx-result-cell-header">Feb 2010</td>
  <td class="ic3-mdx-result-cell-header">Mar 2010</td>
</tr>
<tr>
 <td></td>
 <td></td>
 <td></td>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT
    Head( [Time].[Calendar].[Month].members , Count( Ascendants( [Geography].[Economy].[France] ))) on 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Axis processing using cell evaluations

</div>

<div class="ic3-mdx-example-body" style="display:none">

Similar to calculated member behavior : dimensions are overwritten by the actual slicer content.

In our example, [Economy].[All] is evaluated as the tuple ([Economy].[All],[Geo].[France]).

**Query**

```
SELECT
    Iif( [Geography].[Economy].[All] = 4, [Time].[Calendar].[2010], [Time].[Calendar].[2011] ) on 0
    --                                 ^
    --                          the value of [France]
FROM
    [Sales]
WHERE
    ( [Geography].[Geo].[France] )
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">2010</td>
</tr>
<tr>
 <td>4</td>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT ( [Time].[Calendar].[2010], [Geography].[Geo].[France] ) on 0
FROM [Sales]
```


 
</div>

                                                                                                            

### See Also


[Where Clause](Where%20Clause.md)

[Where Set Clause Exists](Where%20Set%20Clause%20Exists.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
